using System;
using System.Collections;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.GUI;
using gov.va.med.vbecs.GUI.controls;

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// Looks up a VistA user in a supplied list (previously retrieved from a currently connected VistA system). 
	/// </summary>
	public class dlgVistAUsers : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private ICollection _vistaUsers;
		private bool _firstTimeActivated;
		private VbecsVistAUser _selectedUser;

		private System.Windows.Forms.ColumnHeader colName;
		private System.Windows.Forms.Button btnCancel;
		private VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpVistAUsers;
		private System.Windows.Forms.ListView lvVistAUsers;
		private System.Windows.Forms.ColumnHeader colDUZ;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.HelpProvider helpProvider1;
		private System.Windows.Forms.ToolTip toolTip1;
		private VbecsButton btnSearch;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.GroupBox grpSearchCriteria;
		private System.Windows.Forms.Label lblDUZ;
		private System.Windows.Forms.TextBox txtDUZ;
		private System.Windows.Forms.Label lblName;
		private System.Windows.Forms.TextBox txtName;
		private System.ComponentModel.IContainer components;

		#region VistaUserListViewItem Implementation

		private class VistaUserListViewItem : ListViewItem
		{
			public readonly VbecsVistAUser VistAUser;

			public VistaUserListViewItem( VbecsVistAUser vistaAser )
			{
				if( vistaAser == null )
					throw( new ArgumentNullException( "vistaAser" ) );

				VistAUser = vistaAser;

				this.SubItems[0].Text = VistAUser.Duz;
				this.SubItems.Add( VistAUser.UserName );
			}
		}

		#endregion

		/// <summary>
		/// Constructor
		/// </summary>
		public dlgVistAUsers()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			this.vbecsLogo1.Title = this.Text;
			this.RequiredFieldsLabel = true;

			_vistaUsers = null;
			_selectedUser = null;
			_firstTimeActivated = true;
			DialogResult = DialogResult.Cancel;

			btnSearch.Text = "&Search";
			btnOK.Text = "&OK";
			btnCancel.Text = "&Cancel";
			
			UpdateButtons();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="vistaUsers"></param>
		public dlgVistAUsers( ICollection vistaUsers ) : this()
		{
			if( vistaUsers == null )
				throw( new ArgumentNullException( "vistaUsers" ) );
			
			_vistaUsers = vistaUsers;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(dlgVistAUsers));
			this.grpVistAUsers = new System.Windows.Forms.GroupBox();
			this.lvVistAUsers = new System.Windows.Forms.ListView();
			this.colDUZ = new System.Windows.Forms.ColumnHeader();
			this.colName = new System.Windows.Forms.ColumnHeader();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.helpProvider1 = new System.Windows.Forms.HelpProvider();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.grpSearchCriteria = new System.Windows.Forms.GroupBox();
			this.txtName = new System.Windows.Forms.TextBox();
			this.lblName = new System.Windows.Forms.Label();
			this.txtDUZ = new System.Windows.Forms.TextBox();
			this.lblDUZ = new System.Windows.Forms.Label();
			this.btnSearch = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.grpVistAUsers.SuspendLayout();
			this.grpSearchCriteria.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(392, 30);
			this.vbecsLogo1.Title = "VistA Users";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 300);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// grpVistAUsers
			// 
			this.grpVistAUsers.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpVistAUsers.Controls.Add(this.lvVistAUsers);
			this.grpVistAUsers.Location = new System.Drawing.Point(4, 104);
			this.grpVistAUsers.Name = "grpVistAUsers";
			this.grpVistAUsers.Size = new System.Drawing.Size(384, 184);
			this.grpVistAUsers.TabIndex = 1;
			this.grpVistAUsers.TabStop = false;
			this.grpVistAUsers.Text = "Select a VistA User*";
			// 
			// lvVistAUsers
			// 
			this.lvVistAUsers.Activation = System.Windows.Forms.ItemActivation.TwoClick;
			this.lvVistAUsers.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvVistAUsers.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						   this.colDUZ,
																						   this.colName});
			this.lvVistAUsers.FullRowSelect = true;
			this.lvVistAUsers.HideSelection = false;
			this.lvVistAUsers.Location = new System.Drawing.Point(8, 16);
			this.lvVistAUsers.MultiSelect = false;
			this.lvVistAUsers.Name = "lvVistAUsers";
			this.lvVistAUsers.Size = new System.Drawing.Size(368, 160);
			this.lvVistAUsers.TabIndex = 3;
			this.lvVistAUsers.View = System.Windows.Forms.View.Details;
			this.lvVistAUsers.ItemActivate += new System.EventHandler(this.lvVistAUsers_ItemActivate);
			this.lvVistAUsers.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvVistAUsers_ColumnClick);
			this.lvVistAUsers.SelectedIndexChanged += new System.EventHandler(this.lvVistAUsers_SelectedIndexChanged);
			// 
			// colDUZ
			// 
			this.colDUZ.Text = "DUZ";
			this.colDUZ.Width = 125;
			// 
			// colName
			// 
			this.colName.Text = "Name";
			this.colName.Width = 230;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(316, 292);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 5;
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(236, 292);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 4;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.DataMember = "";
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// grpSearchCriteria
			// 
			this.grpSearchCriteria.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearchCriteria.Controls.Add(this.txtName);
			this.grpSearchCriteria.Controls.Add(this.lblName);
			this.grpSearchCriteria.Controls.Add(this.txtDUZ);
			this.grpSearchCriteria.Controls.Add(this.lblDUZ);
			this.grpSearchCriteria.Controls.Add(this.btnSearch);
			this.grpSearchCriteria.Location = new System.Drawing.Point(4, 32);
			this.grpSearchCriteria.Name = "grpSearchCriteria";
			this.grpSearchCriteria.Size = new System.Drawing.Size(384, 68);
			this.grpSearchCriteria.TabIndex = 0;
			this.grpSearchCriteria.TabStop = false;
			this.grpSearchCriteria.Text = "Search Criteria*";
			// 
			// txtName
			// 
			this.txtName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtName.Location = new System.Drawing.Point(68, 40);
			this.txtName.Name = "txtName";
			this.txtName.Size = new System.Drawing.Size(232, 20);
			this.txtName.TabIndex = 1;
			this.txtName.Text = "";
			this.txtName.TextChanged += new System.EventHandler(this.SearchCriteria_TextChanged);
			this.txtName.KeyUp += new System.Windows.Forms.KeyEventHandler(this.SearchTextboxes_KeyUp);
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(8, 40);
			this.lblName.Name = "lblName";
			this.lblName.Size = new System.Drawing.Size(60, 20);
			this.lblName.TabIndex = 5;
			this.lblName.Text = "Name";
			this.lblName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDUZ
			// 
			this.txtDUZ.Location = new System.Drawing.Point(68, 16);
			this.txtDUZ.MaxLength = 19;
			this.txtDUZ.Name = "txtDUZ";
			this.txtDUZ.Size = new System.Drawing.Size(185, 20);
			this.txtDUZ.TabIndex = 0;
			this.txtDUZ.Text = "";
			this.txtDUZ.TextChanged += new System.EventHandler(this.SearchCriteria_TextChanged);
			this.txtDUZ.KeyUp += new System.Windows.Forms.KeyEventHandler(this.SearchTextboxes_KeyUp);
			// 
			// lblDUZ
			// 
			this.lblDUZ.Location = new System.Drawing.Point(8, 16);
			this.lblDUZ.Name = "lblDUZ";
			this.lblDUZ.Size = new System.Drawing.Size(28, 20);
			this.lblDUZ.TabIndex = 3;
			this.lblDUZ.Text = "DUZ";
			this.lblDUZ.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnSearch
			// 
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.Location = new System.Drawing.Point(304, 38);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(75, 23);
			this.btnSearch.TabIndex = 2;
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// dlgVistAUsers
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(392, 316);
			this.Controls.Add(this.grpSearchCriteria);
			this.Controls.Add(this.grpVistAUsers);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MinimumSize = new System.Drawing.Size(400, 340);
			this.Name = "dlgVistAUsers";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VistA Users";
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpVistAUsers, 0);
			this.Controls.SetChildIndex(this.grpSearchCriteria, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpVistAUsers.ResumeLayout(false);
			this.grpSearchCriteria.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Activated Event
		/// </summary>
		/// <param name="e"></param>
		protected override void OnActivated(EventArgs e)
		{
			base.OnActivated (e);

			if( !_firstTimeActivated )
				return;

			_firstTimeActivated = false;

			GuiUtility.SetListViewReadonlyErrorMessage( lvVistAUsers, StrRes.OtherMsg.MUC03.EnterSearchCriteria().ResString );
			SetThisToolTip( btnCancel, StrRes.Tooltips.MUC03.ClickToCancelVistaUserSelection() );
		}

		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			PerformSearch();
		}

		private void lvVistAUsers_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			ColumnClickSorter.ColumnClickHandler( sender, e, true, ColumnClickSorter.ColumnSortType.String );
		}

		private void PerformSearch()
		{
			using( new WaitCursor() )
			{
				lvVistAUsers.BeginUpdate();			
				
				ScanVistaUsersListAndPopulateListView();
				
				if( lvVistAUsers.Items.Count == 0 )
					GuiUtility.SetListViewReadonlyErrorMessage( lvVistAUsers, StrRes.OtherMsg.MUC03.NoVistAUsersFound().ResString );
				else
					GuiUtility.ReenableDetailedListView( lvVistAUsers );

				lvVistAUsers.EndUpdate();

				UpdateButtons();
			}
		}

		private void ScanVistaUsersListAndPopulateListView()
		{			
			string _duzToFind = txtDUZ.Text.Trim().ToUpper();
			string _nameToFind = txtName.Text.Trim().ToUpper();

			bool _searchByDuz = ( _duzToFind.Length > 0 );
			bool _searchByName = ( _nameToFind.Length > 0 );

			lvVistAUsers.Items.Clear();

			foreach( VbecsVistAUser _user in _vistaUsers )
			{
				if( _searchByDuz && !_user.Duz.ToUpper().Trim().StartsWith( _duzToFind ) )
					continue;
				
				if( _searchByName && _user.UserName.ToUpper().IndexOf( _nameToFind ) < 0 )
					continue;

				lvVistAUsers.Items.Add( new VistaUserListViewItem( _user ) );
			}
		}

		private bool IsSearchCriteriaAvailable
		{
			get
			{
				return txtDUZ.Text.Trim().Length > 0 || txtName.Text.Trim().Length > 0;
			}
		}

		private bool IsValidSelectionMade
		{
			get
			{
				return IsSearchCriteriaAvailable && ( lvVistAUsers.View == View.Details ) && ( lvVistAUsers.SelectedItems.Count > 0 );
			}
		}

		private void UpdateButtons()
		{
			btnSearch.Enabled = IsSearchCriteriaAvailable;

			if( IsSearchCriteriaAvailable )
			{
				btnSearch.SetToolTip( StrRes.Tooltips.MUC03.ClickToSearchVista().ResString );
				btnOK.EnabledButton = IsValidSelectionMade;

				if( lvVistAUsers.Items.Count == 0 )
					btnOK.SetToolTip( StrRes.OtherMsg.MUC03.NoVistAUsersFound().ResString );
				else
					btnOK.SetToolTip( IsValidSelectionMade ? StrRes.Tooltips.MUC03.ClickToSelectVistaUser().ResString : StrRes.Tooltips.MUC03.PleaseSelectVistaUser().ResString );
			}
			else
			{				
				btnOK.EnabledButton = false;

				btnSearch.SetToolTip( StrRes.Tooltips.MUC03.EnterSearchCriteria().ResString );
				btnOK.SetToolTip( StrRes.Tooltips.MUC03.EnterSearchCriteria().ResString );				
			}
		}

		private void SearchCriteria_TextChanged(object sender, System.EventArgs e)
		{
			UpdateButtons();
		}

		private void lvVistAUsers_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			UpdateButtons();
		}

		private void lvVistAUsers_ItemActivate(object sender, System.EventArgs e)
		{		
			// using the button here to avoid an extra call to validation.
			if( btnOK.Enabled ) 
				btnOK.PerformClick();
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			_selectedUser = ((VistaUserListViewItem)lvVistAUsers.SelectedItems[0]).VistAUser;

			DialogResult = DialogResult.OK;
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			_selectedUser = null;
		}

		/// <summary>
		/// Get SelectedVistAUser
		/// </summary>
		public VbecsVistAUser SelectedVistAUser
		{
			get
			{
				return _selectedUser;
			}
		}

		private void SearchTextboxes_KeyUp(object sender, KeyEventArgs e)
		{
			// using the button here to avoid an extra call to validation.
			if( e.KeyCode == Keys.Return && btnSearch.Enabled )
				btnSearch.PerformClick(); 
		}
	}
}
